# 3d: Housing entry prices increase over time
# Housing entry prices increase by 2 per cent more than base scenario housing entry price each year. Housing returns are at historical rates.


# Prelims -----------------------------------------------------------------

gc()


# Read in base housing params ---------------------------------------------

## starting cohort pathways (from step 3)
starting_cohorts_pathways <- qread(starting_cohorts_pathways_file)


## housing "savings" AND "drawdowns" given historical housing returns
housing_asset_saving <- qread("./Input data/saving_housing_a.qs") %>% 
  select(age_grp2, housing_asset_saving_param_adj = upsize_rate_housing)


# Adjust for scenario -----------------------------------------------------


## Increase value of housing when purchased by 2% each year
new_housing_value_adj <- starting_cohorts_pathways %>% 
  distinct(year, total_inc_qtile, new_housing_val_param) %>% 
  mutate(new_housing_val_param_adj = new_housing_val_param*(1.02)^(year)) 


ggplot(new_housing_value_adj %>% pivot_longer(cols=contains("param"), names_to="param_type", values_to="param_value")) + 
  geom_line(aes(x = year, y = param_value, colour=param_type)) +
  facet_wrap(vars(total_inc_qtile))



# Put into new version of starting_cohorts, convert to year list and save --------

starting_cohorts_pathways_adj <- starting_cohorts_pathways %>% 
  left_join(new_housing_value_adj) %>% 
  ## replace values
  select( -new_housing_val_param, new_housing_val_param = new_housing_val_param_adj ) %>% 
  ## adjust housing asset returns to historical 7%
  mutate(housing_asset_return_param = 0.07) %>% 
  ## housing saving given historical rates
  left_join(housing_asset_saving) %>% 
  select(-housing_asset_saving_param, housing_asset_saving_param = housing_asset_saving_param_adj)



## split into list by year - save for use in model running
year_list_0 <- starting_cohorts_pathways_adj %>% 
  split(., .$year) 

qsave(year_list_0, "./Output data/year_list_0_higher_housing_entry_price.qs")
